/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.map_markers;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.map.CustomDataHolder;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3620;

public class WeatheredMap {
    private static final String ANTIQUE_KEY = "antique";
    private static final class_2960 ANTIQUE_ID;
    private static final class_3620 ANTIQUE_LIGHT;
    private static final class_3620 ANTIQUE_DARK;
    private static final Object2ObjectArrayMap<class_3620, class_3620> ANTIQUE_COLORS;

    public static void setup() {
        MapDecorationRegistry.registerCustomMapSavedData((class_2960)ANTIQUE_ID, Boolean.TYPE, t -> t.method_10577(ANTIQUE_KEY), (t, b) -> t.method_10556(ANTIQUE_KEY, b.booleanValue()), WeatheredMap::update, WeatheredMap::onTooltip);
    }

    public static class_2561 onTooltip(class_22 data, class_1799 stack, boolean antique) {
        if (antique) {
            return class_2561.method_43471((String)"filled_map.antique.tooltip").method_27692(class_124.field_1080);
        }
        return null;
    }

    public static boolean update(class_22 data, class_1297 entity, boolean antique) {
        if (!antique) {
            return false;
        }
        class_1937 level = entity.field_6002;
        if (level.method_27983() != data.field_118 || !(entity instanceof class_1657)) {
            return false;
        }
        int scale = 1 << data.field_119;
        int mapX = data.field_116;
        int mapZ = data.field_115;
        int playerX = class_3532.method_15357((double)(entity.method_23317() - (double)mapX)) / scale + 64;
        int playerZ = class_3532.method_15357((double)(entity.method_23321() - (double)mapZ)) / scale + 64;
        int centerY = 128 / scale;
        if (level.method_8597().comp_643()) {
            centerY /= 2;
        }
        class_22.class_23 player = data.method_101((class_1657)entity);
        ++player.field_131;
        boolean flag = false;
        for (int pixelX = playerX - centerY + 1; pixelX < playerX + centerY; ++pixelX) {
            if ((pixelX & 0xF) != (player.field_131 & 0xF) && !flag) continue;
            flag = false;
            double somethingY = 0.0;
            for (int pixelZ = playerZ - centerY - 1; pixelZ < playerZ + centerY; ++pixelZ) {
                if (pixelX < 0 || pixelZ < -1 || pixelX >= 128 || pixelZ >= 128) continue;
                int offsetX = pixelX - playerX;
                int offsetZ = pixelZ - playerZ;
                boolean outRadius = offsetX * offsetX + offsetZ * offsetZ > (centerY - 2) * (centerY - 2);
                int worldX = (mapX / scale + pixelX - 64) * scale;
                int worldZ = (mapZ / scale + pixelZ - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                class_2818 levelchunk = level.method_8500(new class_2338(worldX, 0, worldZ));
                if (levelchunk.method_12223()) continue;
                class_1923 chunkpos = levelchunk.method_12004();
                int chunkCoordX = worldX & 0xF;
                int chunkCoordZ = worldZ & 0xF;
                double maxY = 0.0;
                int distanceFromLand = 8;
                HashMap<class_2338, Boolean> isWaterMap = new HashMap<class_2338, Boolean>();
                if (level.method_8597().comp_643()) {
                    int l3 = worldX + worldZ * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)class_2246.field_10566.method_9564().method_26205((class_1922)level, class_2338.field_10980), 10);
                    } else {
                        multiset.add((Object)class_2246.field_10113.method_9564().method_26205((class_1922)level, class_2338.field_10980), 100);
                    }
                    maxY = 100.0;
                    distanceFromLand = 0;
                } else {
                    class_2338.class_2339 mutable1 = new class_2338.class_2339();
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ - scale)) {
                        --distanceFromLand;
                    }
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ)) {
                        --distanceFromLand;
                    }
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ + scale)) {
                        --distanceFromLand;
                    }
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ - scale)) {
                        --distanceFromLand;
                    }
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ)) {
                        --distanceFromLand;
                    }
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ + scale)) {
                        --distanceFromLand;
                    }
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX, worldZ - scale)) {
                        --distanceFromLand;
                    }
                    if (WeatheredMap.isWaterAt(level, isWaterMap, scale, worldX, worldZ + scale)) {
                        --distanceFromLand;
                    }
                    for (int scaleOffsetX = 0; scaleOffsetX < scale; ++scaleOffsetX) {
                        for (int scaleOffsetZ = 0; scaleOffsetZ < scale; ++scaleOffsetZ) {
                            int cY = levelchunk.method_12005(class_2902.class_2903.field_13202, scaleOffsetX + chunkCoordX, scaleOffsetZ + chunkCoordZ) + 1;
                            class_3620 newColor = null;
                            if (cY <= level.method_31607() + 1) {
                                newColor = class_2246.field_9987.method_9564().method_26205((class_1922)level, (class_2338)mutable1);
                            } else {
                                class_2680 blockState;
                                class_3620 temp;
                                do {
                                    mutable1.method_10103(chunkpos.method_8326() + scaleOffsetX + chunkCoordX, --cY, chunkpos.method_8328() + scaleOffsetZ + chunkCoordZ);
                                    blockState = levelchunk.method_8320((class_2338)mutable1);
                                    temp = blockState.method_26205((class_1922)level, (class_2338)mutable1);
                                    if (temp == class_3620.field_16008 || temp == class_3620.field_16019 || !blockState.method_26220((class_1922)level, (class_2338)mutable1).method_1110()) continue;
                                    newColor = class_3620.field_15999;
                                } while (temp == class_3620.field_16008 && cY > level.method_31607());
                                if (newColor == null) {
                                    newColor = blockState.method_26205((class_1922)level, (class_2338)mutable1);
                                }
                            }
                            data.method_109((class_1922)level, chunkpos.method_8326() + scaleOffsetX + chunkCoordX, chunkpos.method_8328() + scaleOffsetZ + chunkCoordZ);
                            maxY += (double)cY / (double)(scale * scale);
                            multiset.add((Object)newColor);
                        }
                    }
                }
                int relativeShade = 1;
                class_3620 materialcolor = (class_3620)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)class_3620.field_16008);
                if (materialcolor == class_3620.field_16019) {
                    materialcolor = class_3620.field_15987;
                    if (distanceFromLand > 7 && pixelZ % 2 == 0) {
                        relativeShade = (pixelX + (int)(class_3532.method_15374((float)((float)pixelZ + 0.0f)) * 7.0f)) / 8 % 5;
                        if (relativeShade == 3) {
                            relativeShade = 1;
                        } else if (relativeShade == 4) {
                            relativeShade = 0;
                        }
                    } else if (distanceFromLand > 7) {
                        materialcolor = ANTIQUE_LIGHT;
                        relativeShade = 2;
                    } else if (distanceFromLand > 5) {
                        relativeShade = 1;
                    } else if (distanceFromLand > 3) {
                        relativeShade = 0;
                    }
                } else if (distanceFromLand > 0) {
                    relativeShade = 3;
                    materialcolor = class_3620.field_15977;
                    if (distanceFromLand > 3) {
                        relativeShade = 1;
                    }
                } else {
                    double depthY = (maxY - somethingY) * 4.0 / (double)(scale + 4) + ((double)(pixelX + pixelZ & 1) - 0.5) * 0.4;
                    if (depthY > 0.6) {
                        relativeShade = 2;
                    }
                    if (depthY < -0.6) {
                        relativeShade = 0;
                    }
                    materialcolor = (class_3620)ANTIQUE_COLORS.getOrDefault((Object)materialcolor, (Object)ANTIQUE_DARK);
                }
                somethingY = maxY;
                if (pixelZ < 0 || offsetX * offsetX + offsetZ * offsetZ >= centerY * centerY || outRadius && (pixelX + pixelZ & 1) == 0) continue;
                flag |= data.method_32365(pixelX, pixelZ, (byte)(materialcolor.field_16021 * 4 + relativeShade));
            }
        }
        return true;
    }

    private static boolean isWaterAt(class_1937 level, Map<class_2338, Boolean> map, int scale, int x, int z) {
        class_2338 pos = new class_2338(x, 0, z);
        return map.computeIfAbsent(pos, p -> {
            int y = level.method_8624(class_2902.class_2903.field_13202, x, z) - 1;
            return level.method_8316(pos.method_10086(y)).method_15769();
        });
    }

    public static void setAntique(class_3218 level, class_1799 stack, boolean on) {
        class_22 mapitemsaveddata = class_1806.method_8001((class_1799)stack, (class_1937)level);
        if (mapitemsaveddata instanceof ExpandedMapData) {
            ExpandedMapData n;
            CustomDataHolder.Instance instance;
            ExpandedMapData data = (ExpandedMapData)mapitemsaveddata;
            class_22 newData = data.copy();
            if (newData instanceof ExpandedMapData && (instance = (CustomDataHolder.Instance)(n = (ExpandedMapData)newData).getCustomData().get(ANTIQUE_ID)) != null) {
                CustomDataHolder.Instance antique = instance;
                antique.set((Object)on);
            }
            int mapId = level.method_17889();
            String mapKey = class_1806.method_17440((int)mapId);
            level.method_17890(mapKey, newData);
            stack.method_7948().method_10569("map", mapId);
        }
    }

    static {
        class_3620 materialColor1;
        class_3620 materialColor;
        ANTIQUE_ID = Supplementaries.res(ANTIQUE_KEY);
        ANTIQUE_COLORS = new Object2ObjectArrayMap();
        try {
            Class<class_3620> cl = class_3620.class;
            Constructor cons = cl.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
            cons.setAccessible(true);
            materialColor = (class_3620)cons.newInstance(62, 13870193);
            materialColor1 = (class_3620)cons.newInstance(63, 10976850);
        }
        catch (Exception e) {
            materialColor = class_3620.field_16003;
            materialColor1 = class_3620.field_33533;
            Supplementaries.LOGGER.warn("Failed to add custom map colors for antique map: " + e);
        }
        ANTIQUE_DARK = materialColor1;
        ANTIQUE_LIGHT = materialColor;
        ANTIQUE_COLORS.put((Object)class_3620.field_16023, (Object)class_3620.field_16000);
        ANTIQUE_COLORS.put((Object)class_3620.field_33532, (Object)class_3620.field_16000);
        ANTIQUE_COLORS.put((Object)class_3620.field_16004, (Object)class_3620.field_15977);
        ANTIQUE_COLORS.put((Object)class_3620.field_16000, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)class_3620.field_15996, (Object)class_3620.field_15996);
        ANTIQUE_COLORS.put((Object)class_3620.field_15978, (Object)class_3620.field_15977);
        ANTIQUE_COLORS.put((Object)class_3620.field_16007, (Object)class_3620.field_16007);
        ANTIQUE_COLORS.put((Object)class_3620.field_16009, (Object)class_3620.field_16007);
        ANTIQUE_COLORS.put((Object)class_3620.field_15986, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)class_3620.field_16025, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)class_3620.field_16022, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)class_3620.field_16005, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)class_3620.field_15979, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)class_3620.field_15977, (Object)class_3620.field_15992);
    }
}

